<?php
// Sample data array
$data = [
    (object)[
        'card_id' => '123',
        'brand' => 'Visa',
        'last_four' => '1234',
        'status' => 'Active',
        'created_at' => '2025-01-28 12:00:00'
    ],
    (object)[
        'card_id' => '124',
        'brand' => 'Mastercard',
        'last_four' => '5678',
        'status' => 'Inactive',
        'created_at' => '2025-01-27 14:00:00'
    ]
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Virtual Cards</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
        }
        .page-content {
            padding: 20px;
        }
        .card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin: 10px 0;
            padding: 20px;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background: green;
            color: white;
            border-radius: 5px;
            text-decoration: none;
            text-align: center;
        }
        .btn-success {
            background-color: #28a745;
        }
        .btn-success:hover {
            background-color: #218838;
        }
        .divider {
            height: 1px;
            background: #ddd;
            margin: 10px 0;
        }
        .text-danger {
            color: red;
        }
    </style>
</head>
<body>
    <div class="page-content header-clear-medium">
        <div class="card card-style p-3">
            <a href="create-card" class="btn btn-success mb-5">Create New Card</a>
            <?php if (!empty($data)) {
                foreach ($data as $list) { ?>
                    <a href="virtual-card-details?card_id=<?php echo $list->card_id; ?>" class="d-flex">
                        <div class="align-self-center">
                            <span class="icon icon-s gradient-green color-white rounded-sm shadow-xxl">
                                <i class="fa fa-credit-card font-15"></i>
                            </span>
                        </div>
                        <div class="align-self-center">
                            <h6 class="ps-3 font-12 mt-3 color-theme opacity-70">
                                <?php echo $list->brand; ?> **** <?php echo $list->last_four; ?>
                            </h6>
                        </div>
                        <div class="ms-auto text-end align-self-center">
                            <h5 class="color-theme font-15 font-700 d-block mb-n1"><?php echo $list->status; ?></h5>
                            <span class="color-green-dark font-10">
                                <?php echo date('d M Y', strtotime($list->created_at)); ?>
                                <i class="fa fa-check-circle"></i>
                            </span>
                        </div>
                    </a>
                    <div class="divider my-3"></div>
                <?php }
            } else {
                echo "<h3 class='text-danger'>You have not created any cards yet</h3>";
            } ?>
        </div>
    </div>
</body>
</html>

