<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="#A44AFF">
    <title>JiffyPlug-Login</title>
    
    <!-- Bootstrap 5 CDN-Import: -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <!-- Light-Theming: -->
    <link id="mainStyle" rel="stylesheet" href="assets/css/style.css">

    <!-- Dark-Theming: -->
    <!-- Uncomment the line below to use dark theming. Don't forget to comment the line above.-->
    <!-- <link rel="stylesheet" href="assets/css/style_dark.css"> -->
    <!-- this also works automatically by clicking the theme_button. -->
</head>
<body>

    <div class="page-content d-flex align-items-center">

        <div class="container d-flex justify-content-center">

            <div class="col-12 col-sm-10 col-md-8 col-lg-7 col-xl-6 col-xxl-5">

                <div class="auth-card">

                    <div class="logo-area">

                        <!-- Light-Theming Logo: -->
                        <!--img id="header_logo" class="logo" src="assets/img/logo.png" />

                        <!-- Dark-Theming: -->
                        <!-- <img class="logo" src="assets/img/logo_dark.png" /> -->

                    </div>

                    <!--h5 class="auth-title"><?php echo $sitename; ?></h5-->
                
                <div class="user-top text-center mt-n5">
                    <img src="../../assets/images/icons/user-smile.png" style="border-radius:5rem; width:100px; height:100px; margin-right:10px;">
                    <h1 class="font-25 mt-2 mb-3 color-highlight">LOGIN</h1>
                    <h6 class="mb-1 mt-2 color-highlight" id="accountname">Welcome To <?php echo $sitename; ?></h6>
                </div>

                    <div id="logininputes">

                   <!-- Login-Form-->
<form id="login-form" method="post">

    <div class="mb-2 mt-5" id="phonediv">
        <input type="number" class="form-control auth-input" id="phonelogin" name="phone" placeholder="Phone Number" required autocomplete="tel">

    </div>

    <div class="mb-3">
        <input type="password" class="form-control auth-input" id="passwordlogin" name="password" placeholder="Password" required />
        <label for="passwordlogin" class="color-highlight">Password</label>
        <em>(required)</em>
    </div>

    <button type="submit" id="submit-btn" class="btn auth-btn mt-2 mb-4">Login</button>

</form>

                    <p class="text mb-1"><a href="../recovery/" class="text-link">Forgot</a> Password?</p>
                    <p class="text mb-4">Create new  <a href="../register/" class="text-link">Account?</a></p>

                </div>
            </div>
        </div>
    </div>

    <button id="theme_button" class="btn btn-theme" onclick="onThemeChange()">
        <i id="theme_icon" class="fas fa-moon"></i>
    </button>

<style>
    /* Body Styling */
body {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    background: #f4f4f4; /* Light grey background */
    font-family: 'Poppins', sans-serif;
}
/* Futuristic Shape Before Logo */
.logo-area {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
}

.logo-area::before {
    content: "";
    position: absolute;
    left: -20px;
    width: 80px;
    height: 10px;
    background: linear-gradient(90deg, #A44AFF, #FF8CFF);
    border-radius: 50px;
    top: 50%;
    transform: translateY(-50%) skewX(-20deg);
    box-shadow: 0px 0px 10px rgba(164, 74, 255, 0.6);
}

/* Premium Glow Effect */
.logo {
    filter: drop-shadow(0px 0px 10px rgba(255, 140, 255, 0.7));
    transition: all 0.3s ease-in-out;
}

.logo:hover {
    filter: drop-shadow(0px 0px 20px rgba(255, 140, 255, 1));
    transform: scale(1.05);
}

/* Login Card */
.auth-card {
    background: #ffffff;
    border-radius: 12px;
    padding: 35px;
    text-align: center;
    box-shadow: 10px 10px 30px rgba(0, 0, 0, 0.1); /* Smooth shadow */
    transition: transform 0.3s ease-in-out;
}

/* Add a subtle hover effect */
.auth-card:hover {
    transform: translateY(-5px);
}

/* User Profile Image */
.user-top img {
    border-radius: 50%;
    width: 90px;
    height: 90px;
    border: 3px solid #A44AFF;
    box-shadow: 0px 0px 10px rgba(164, 74, 255, 0.3);
}

/* Input Fields */
.auth-input {
    width: 100%;
    padding: 12px;
    margin: 8px 0;
    border: 2px solid #ccc;
    border-radius: 8px;
    font-size: 16px;
    outline: none;
    transition: all 0.3s ease;
    background: #f9f9f9;
}

/* Focus effect */
.auth-input:focus {
    border-color: #A44AFF;
    box-shadow: 0px 0px 8px rgba(164, 74, 255, 0.5);
}

/* Buttons */
.auth-btn {
    width: 100%;
    padding: 12px;
    font-size: 18px;
    background: #A44AFF;
    color: white;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 3px 3px 10px rgba(164, 74, 255, 0.4);
}

/* Button Hover */
.auth-btn:hover {
    background: #8C32FF;
    transform: scale(1.05);
    box-shadow: 5px 5px 15px rgba(164, 74, 255, 0.5);
}

/* Pressing effect */
.auth-btn:active {
    transform: scale(0.98);
    box-shadow: none;
}

/* Links */
.text-link {
    color: #A44AFF;
    font-weight: bold;
    text-decoration: none;
    transition: all 0.3s ease;
}

.text-link:hover {
    color: #6D22CC;
    text-decoration: underline;
}

</style>
    <script type="text/javascript">
        function onThemeChange() {
            let cssStyleSheet = document.getElementById("mainStyle");
            let path = (cssStyleSheet.href).substring((cssStyleSheet.href).length-9, (cssStyleSheet.href).length);
            if(path === "style.css") {
                cssStyleSheet.href = "assets/css/style_dark.css";
                document.getElementById("header_logo").src = "assets/img/logo_dark.png";
                document.getElementById("theme_icon").className = "fas fa-sun";
            } else {
                cssStyleSheet.href = "assets/css/style.css";
                document.getElementById("header_logo").src = "assets/img/logo.png";
                document.getElementById("theme_icon").className = "fas fa-moon";
            }
        }
    </script>


    <!-- Bootstrap 5 JS-Bundle CDN import: -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            //Save Phone Number
            checkIfPhoneNumberSaved();

            //Enable Form Input
            $("#phonelogin").click(function() {
                $(this).removeAttr("readonly");
            });
            $("#passwordlogin").click(function() {
                $(this).removeAttr("readonly");
            });

            //Login Form
            $('#login-form').submit(function(e) {
                e.preventDefault();
                $('#submit-btn').removeClass("btn-primary");
                $('#submit-btn').addClass("btn-secondary");
                $('#submit-btn').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Processing ...');

                $.ajax({
                    url: '../user/includes/route.php?login',
                    data: new FormData($(this)[0]),
                    cache: false,
                    contentType: false,
                    processData: false,
                    method: 'POST',
                    type: 'POST',
                    success: function(resp) {
                        resp = JSON.parse(resp);
                        if (resp.status == "success") {
                            swal('Success!!', "Login Successful", "success");
                            setTimeout(function() {
                                location.replace('../user/')
                            }, 1000);
                        } else {
                            swal('Alert!!', resp.msg, "error");
                        }
                        $('#submit-btn').removeClass("btn-secondary");
                        $('#submit-btn').addClass("btn-primary");
                        $('#submit-btn').html("<b>Login</b>");
                    }
                });
            });
        });

        function checkIfPhoneNumberSaved() {
            $phone = atob(unescape(getCookie("loginPhone")));
            $name = atob(unescape(getCookie("loginName")));
            if ($phone != null && $phone != "") {
                let msg = '<p class="mb-3"><a href="javascript:showNumber();"><b class="text-primary">Login With Another Account?</b></a></p>';
                $("#accountname").after(msg);
                $("#accountname").append(" " + $name + "!");
                $("#phonediv").hide();
                $("#phonelogin").val($phone);
            }
        }

        function showNumber() {
            $("#phonediv").show();
        }

        function getCookie(cname) {
            var name = cname + "=";
            var ca = document.cookie.split(';');
            for (var i = 0; i < ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') c = c.substring(1);
                if (c.indexOf(name) == 0) return c.substring(name.length, c.length);
            }
            return "";
        }
    </script>

</body>
</html>
