<?php

// Auto Load Classes
require_once("../autoloader.php");
require_once("../../core/helpers/vendor/autoload.php");
header('Content-Type: application/json');
date_default_timezone_set('Africa/Lagos');

$headers = getallheaders();
$response = array();
$controller = new ApiAccess;

$data = @file_get_contents("php://input");
$hookData = json_decode($data);
if ($hookData && $headers['signeddata']) {
    // Check if the code and data properties exist
    if (isset($hookData->code) && isset($hookData->data->response)) {
        $status = ($hookData->code === 200) ? 0 : 1;

        // Accessing the amount and reference safely
        $amount = isset($hookData->data->response->amount) ? $hookData->data->response->amount : null;
        $ref = isset($hookData->data->response->sessionIdOrReference) ? $hookData->data->response->sessionIdOrReference : null;
        // Check if amount and reference are valid
            $checkPayment = $controller->verifyAndCreditUserAccount($amount, $ref, $status, $data, $headers['signeddata']);
            

            
        if ($checkPayment === 0) {
            $response['status'] = 'success';
            $response['message'] = 'Payment processed successfully.';
        } else {
            $response['status'] = 'error';
            $response['message'] = 'Invalid amount or reference.';
        }
    } else {
        $response['status'] = 'error';
        $response['message'] = 'Invalid data structure.';
    }
} else {
    $response['status'] = 'error';
    $response['message'] = 'No data received.';
}




// Return the response as JSON
echo json_encode($response);
?>