<?php
$config = [
    "private_key_bits" => 1024,  // 1024-bit key as required
    "private_key_type" => OPENSSL_KEYTYPE_RSA,
];

// Generate private key
$res = openssl_pkey_new($config);

// Extract the private key
openssl_pkey_export($res, $private_key);
file_put_contents(__DIR__ . "/merchant_private_key.pem", $private_key);

// Extract the public key
$public_key_details = openssl_pkey_get_details($res);
$public_key = $public_key_details["key"];
file_put_contents(__DIR__ . "/merchant_public_key.pem", $public_key);

// Output ONLY the public key (for safe display)
echo "Public Key Generated:\n" . $public_key;

// Log the key generation process (DO NOT log private key)
error_log();

?>
