<?php
// Sample data array
$data = [
    (object)[
        'card_id' => '123',
        'brand' => 'Visa',
        'last_four' => '1234',
        'status' => 'Active',
        'created_at' => '2025-01-28 12:00:00'
    ],
    (object)[
        'card_id' => '124',
        'brand' => 'Mastercard',
        'last_four' => '5678',
        'status' => 'Inactive',
        'created_at' => '2025-01-27 14:00:00'
    ]
];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Virtual Cards</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f9f9fb;
            margin: 0;
            padding: 20px;
        }
        .page-content {
            max-width: 900px;
            margin: 0 auto;
        }
        .btn {
            display: inline-block;
            padding: 12px 20px;
            background: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            text-align: center;
            margin-bottom: 20px;
        }
        .btn:hover {
            background: #0056b3;
        }
        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .card .icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #42d392, #5fa5f9);
            color: white;
            font-size: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            border-radius: 50%;
        }
        .card-content {
            flex: 1;
            margin-left: 15px;
        }
        .card-content h6 {
            font-size: 16px;
            margin: 0 0 5px;
            color: #333;
        }
        .card-content span {
            font-size: 14px;
            color: #888;
        }
        .card-status {
            text-align: right;
        }
        .card-status h5 {
            font-size: 14px;
            margin: 0;
            color: #007bff;
        }
        .card-status span {
            font-size: 12px;
            color: green;
        }
        .empty-state {
            text-align: center;
            color: #aaa;
            margin-top: 50px;
        }
        .empty-state h3 {
            font-size: 18px;
            margin-bottom: 10px;
        }
        .empty-state i {
            font-size: 50px;
            color: #ddd;
        }
        .form-container {
            background: white;
            border-radius: 15px;
            padding: 20px;
            margin-top: 30px;
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
        }
        .form-container h3 {
            margin-bottom: 20px;
            font-size: 20px;
            color: #333;
        }
        .form-container label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #555;
        }
        .form-container input, .form-container select, .form-container button {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .form-container button {
            background: #007bff;
            color: white;
            font-weight: bold;
            cursor: pointer;
        }
        .form-container button:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>
    <div class="page-content">
        <a href="create-card" class="btn">Create New Card</a>
        
        <?php if (!empty($data)) { 
            foreach ($data as $list) { ?>
                <div class="card">
                    <div class="icon">
                        <i class="fa fa-credit-card"></i>
                    </div>
                    <div class="card-content">
                        <h6><?php echo $list->brand; ?> **** <?php echo $list->last_four; ?></h6>
                        <span>Created on: <?php echo date('d M Y', strtotime($list->created_at)); ?></span>
                    </div>
                    <div class="card-status">
                        <h5><?php echo $list->status; ?></h5>
                        <?php if ($list->status === 'Active') { ?>
                            <span><i class="fa fa-check-circle"></i> Active</span>
                        <?php } else { ?>
                            <span style="color: red;"><i class="fa fa-times-circle"></i> Inactive</span>
                        <?php } ?>
                    </div>
                </div>
            <?php }
        } else { ?>
            <div class="empty-state">
                <i class="fa fa-folder-open"></i>
                <h3>No cards created yet</h3>
            </div>
        <?php } ?>

        <div class="form-container">
            <h3>Create Virtual Card</h3>
            <form method="POST" action="">
                <label for="cardName">Card Name</label>
                <input type="text" id="cardName" name="cardName" placeholder="e.g., Travel Card" required>

                <label for="cardType">Card Type</label>
                <select id="cardType" name="cardType" required>
                    <option value="">Select Card Type</option>
                    <option value="personal">Personal</option>
                    <option value="business">Business</option>
                </select>

                <label for="amount">Amount</label>
                <input type="number" id="amount" name="amount" placeholder="Enter amount" required>

                <button type="submit">Create Card</button>
            </form>
        </div>
    </div>
</body>
</html>
